package com.icetech.park.rpc;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.parkvip.IVipProductService;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.domain.parkvip.ParkVipEnum;
import com.icetech.cloudcenter.domain.parkvip.VipProductDto;
import com.icetech.cloudcenter.domain.parkvip.VipProductRule;
import com.icetech.park.service.parkvip.VipProductRuleService;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wangzhiwei
 */
@Service("iVipProductServiceImpl")
@Slf4j
public class IVipProductServiceImpl implements IVipProductService {
    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private VipProductRuleService vipProductRuleService;

    @Override
    public ObjectResponse<List<VipProductDto>> getParkProduct(String parkCode) {
        Park park = parkService.findByParkCode(parkCode).getData();
        List<ParkInoutdevice> parkInoutdevices = parkInoutdeviceDao.selectByParkId(park.getId());
        List<VipProductRule> ruleList = vipProductRuleService.list(Wrappers.lambdaQuery(VipProductRule.class)
                .le(VipProductRule::getChannelMinNum, parkInoutdevices.size())
                .ge(VipProductRule::getChannelMaxNum, parkInoutdevices.size())
                .orderByDesc(VipProductRule::getRecommend,VipProductRule::getProductType));
        List<VipProductDto> vipProductDtos = Lists.newArrayList();
        ruleList.forEach(rule->{
            VipProductDto vipProductDto = new VipProductDto();
            vipProductDto.setPrice(rule.getAmount().setScale(2,BigDecimal.ROUND_HALF_UP).toString());
            vipProductDto.setActivePrice(rule.getDiscountAmount().setScale(2,BigDecimal.ROUND_HALF_UP).toString());
            vipProductDto.setDesc(rule.getRemark());
            vipProductDto.setProductId(rule.getId());
            vipProductDto.setProductType(rule.getProductType());
            vipProductDto.setProductName(rule.getProductName());
            vipProductDto.setRecommend(rule.getRecommend());
            vipProductDtos.add(vipProductDto);
        });
        return ObjectResponse.success(vipProductDtos);
    }

    @Override
    public ObjectResponse<VipProductRule> getTryProduct(String parkCode) {
        Park park = parkService.findByParkCode(parkCode).getData();
        List<ParkInoutdevice> parkInoutdevices = parkInoutdeviceDao.selectByParkId(park.getId());
        if (CollectionUtils.isEmpty(parkInoutdevices)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(),"当前车场没有通道");
        }
        List<VipProductRule> ruleList = vipProductRuleService.list(Wrappers.lambdaQuery(VipProductRule.class)
                .le(VipProductRule::getChannelMinNum, parkInoutdevices.size())
                .ge(VipProductRule::getChannelMaxNum, parkInoutdevices.size()));
        VipProductRule vipProductRule = ruleList.stream().filter(rule -> ParkVipEnum.month.getType().equals(rule.getProductType())).findFirst().get();
        return ObjectResponse.returnNotFoundIfNull(vipProductRule);
    }

    @Override
    public ObjectResponse<VipProductRule> getProduct(Integer productId) {
        return ObjectResponse.returnNotFoundIfNull(vipProductRuleService.getById(productId));
    }
}
