package com.icetech.park.rpc;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.parkvip.IParkVipService;
import com.icetech.cloudcenter.api.parkvip.IVipEquitiesService;
import com.icetech.cloudcenter.domain.parkvip.VipEquities;
import com.icetech.cloudcenter.domain.parkvip.VipEquitiesCount;
import com.icetech.cloudcenter.domain.parkvip.VipEquitiesDetailDto;
import com.icetech.cloudcenter.domain.parkvip.VipEquitiesEnum;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.SqlConstant;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.parkvip.VipEquitiesCountService;
import com.icetech.park.service.parkvip.VipEquitiesService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author wangzhiwei
 */
@Service("IVipEquitiesServiceImpl")
@Slf4j
public class IVipEquitiesServiceImpl implements IVipEquitiesService {
    @Autowired
    private VipEquitiesCountService vipEquitiesCountService;
    @Autowired
    private VipEquitiesService vipEquitiesService;
    @Autowired
    private ParkService parkDao;
    @Autowired
    private IParkVipService parkVipService;

    @Override
    public ObjectResponse<Void> countEquities(String parkCode, String userName, Integer type) {
        VipEquities vipEquities = vipEquitiesService.getOne(Wrappers.lambdaQuery(VipEquities.class).eq(VipEquities::getEquitiesCode, VipEquitiesEnum.getCode(type)).last(SqlConstant.LIMIT_ONE));
        if (Objects.isNull(vipEquities)){
            log.warn("[vip权益未设置]############");
            return ObjectResponse.success();
        }
        Park park = parkDao.findByParkCode(parkCode).getData();
        if (Objects.isNull(park)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_402);
        }
        ObjectResponse<Boolean> parkVip = parkVipService.judgeParkVip(parkCode);
        if (!parkVip.getData()){
            log.warn("[当前车场不是vip],parkCode{}",parkCode);
            return ObjectResponse.success();
        }
        VipEquitiesCount equitiesCount = vipEquitiesCountService.getOne(Wrappers.lambdaQuery(VipEquitiesCount.class)
                .eq(VipEquitiesCount::getParkId, park.getId()).and(query->{
                    query.eq(VipEquitiesCount::getVipEquitiesId,vipEquities.getId());
                }).last(SqlConstant.LIMIT_ONE));
        if (Objects.isNull(equitiesCount)){
            VipEquitiesCount vipEquitiesCount = new VipEquitiesCount();
            vipEquitiesCount.setParkId(Math.toIntExact(park.getId()));
            vipEquitiesCount.setVipEquitiesId(vipEquities.getId());
            vipEquitiesCount.setVipEquitiesCount(1);
            vipEquitiesCount.setCreateTime(new Date());
            vipEquitiesCountService.addVipEquitiesCount(vipEquitiesCount);
        }else {
            //更新
            int count = equitiesCount.getVipEquitiesCount() + 1;
            equitiesCount.setVipEquitiesCount(count);
            equitiesCount.setUpdateTime(new Date());
            vipEquitiesCountService.updateById(equitiesCount);
        }
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<VipEquitiesDetailDto> getEquities(String parkCode) {
        Park park = parkDao.findByParkCode(parkCode).getData();
        if (park == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_400, "parkCode不存在");
        }
        VipEquitiesDetailDto vipEquitiesDetailDto = new VipEquitiesDetailDto();
        List<VipEquitiesCount> countList = vipEquitiesCountService.list(Wrappers.lambdaQuery(VipEquitiesCount.class)
                .eq(VipEquitiesCount::getParkId, park.getId()));
        if (CollectionUtil.isEmpty(countList)){
            return ObjectResponse.success(vipEquitiesDetailDto);
        }

        Map<Integer, VipEquitiesCount> collectMap = countList.stream().collect(Collectors.toMap(VipEquitiesCount::getId, Function.identity()));
        collectMap.keySet().forEach(id->{
            VipEquitiesCount vipEquitiesCount = collectMap.get(id);
            VipEquities vipEquities = vipEquitiesService.getVipEquitiesById(vipEquitiesCount.getVipEquitiesId());
            VipEquitiesEnum entity = VipEquitiesEnum.getEntity(vipEquities.getEquitiesCode());
            switch (entity){
                case 滞留车辆推送:
                    vipEquitiesDetailDto.setAlarmCount(vipEquitiesCount.getVipEquitiesCount());
                    break;
                case 云端二次识别:
                    vipEquitiesDetailDto.setDistinguishCount(vipEquitiesCount.getVipEquitiesCount());
                    break;
                case 车主呼叫:
                    vipEquitiesDetailDto.setCallCount(vipEquitiesCount.getVipEquitiesCount());
                    break;
                case 收费员呼出:
                    vipEquitiesDetailDto.setPhoneCount(vipEquitiesCount.getVipEquitiesCount());
                    break;
                default:
                    break;
            }
        });
        vipEquitiesDetailDto.setTotalCount(countList.stream().mapToInt(VipEquitiesCount::getVipEquitiesCount).sum());
        return ObjectResponse.success(vipEquitiesDetailDto);
    }
}
