package com.icetech.park.rpc;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.github.pagehelper.PageHelper;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.parkvip.IVipBuyerRecordService;
import com.icetech.park.dao.parkvip.VipBuyerRecordMapper;
import com.icetech.cloudcenter.domain.parkvip.VipBuyerRecordDto;
import com.icetech.cloudcenter.domain.response.ParkDto;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author wangzhiwei
 */
@Service("iVipBuyerRecordServiceImpl")
@Slf4j
public class IVipBuyerRecordServiceImpl implements IVipBuyerRecordService {
    @Autowired
    private VipBuyerRecordMapper vipBuyerRecordMapper;
    @Autowired
    private ParkService parkService;

    @Override
    public ObjectResponse<Page<VipBuyerRecordDto>> getVipRecordList(Integer pageNo, Integer pageSize, Integer userId) {
        ObjectResponse<List<ParkDto>> parkList = parkService.getParkList(userId);
        List<Long> parkIds = parkList.getData().stream().map(ParkDto::getId).collect(Collectors.toList());
        com.github.pagehelper.Page<VipBuyerRecordDto> page = PageHelper.startPage(pageNo, pageSize).doSelectPage(() -> {
            vipBuyerRecordMapper.getVipRecordList(parkIds,userId);
        });
        DateTime date = DateUtil.date();
        page.getResult().forEach(item->{
            item.setStatus(date.getTime()>=DateUtil.endOfDay(item.getExpirationTime()).getTime()?0:1);
        });
        return ObjectResponse.success(com.icetech.common.domain.Page.instance(page.getPages(),page.getTotal(),page.getResult()));
    }
}
