package com.icetech.park.rpc;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.icetech.cloudcenter.api.constants.MqConstants;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.parkvip.IParkVipUserService;
import com.icetech.user.dao.SaasUserDao;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.user.domain.entity.user.SaasUser;
import com.icetech.cloudcenter.domain.parkvip.ParkAuthUserBaseDto;
import com.icetech.cloudcenter.domain.parkvip.ParkAuthUserDto;
import com.icetech.cloudcenter.domain.parkvip.ParkVip;
import com.icetech.cloudcenter.domain.parkvip.ParkVipUser;
import com.icetech.cloudcenter.domain.parkvip.ParkuserAuthStatus;
import com.icetech.cloudcenter.domain.response.ParkDto;
import com.icetech.cloudcenter.domain.vo.VipNotifyEmailVO;
import com.icetech.park.service.parkvip.CallSipService;
import com.icetech.park.service.parkvip.ParkVipService;
import com.icetech.park.service.parkvip.ParkVipUserService;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.SqlConstant;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.mq.sender.RabbitSender;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author wangzhiwei
 */
@Service("iParkVipUserServiceImpl")
@Slf4j
public class IParkVipUserServiceImpl implements IParkVipUserService {
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkVipUserService parkVipUserService;
    @Autowired
    private ParkVipService parkVipService;
    @Autowired
    private SaasUserDao saasUserDao;
    @Autowired
    private RabbitSender rabbitSender;
    @Autowired
    private CallSipService callSipService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ObjectResponse<Void> authUserVip(String parkCode, List<String> accounts, String phoneNum) {
        Park park = parkService.findByParkCode(parkCode).getData();
        if (Objects.isNull(park)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_402);
        }
        //查询该车场vip信息
        ParkVip parkVip = parkVipService.getOne(Wrappers.lambdaQuery(ParkVip.class).eq(ParkVip::getParkId, park.getId()).last(SqlConstant.LIMIT_ONE));
        if (Objects.isNull(parkVip) || parkVip.getStatus() == 0){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_402.getCode(),park.getParkName()+"此车场不是VIP");
        }
        if (parkVip.getMaxUserNum()<accounts.size()){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_402.getCode(),"当前车场最大授权个数为"+parkVip.getMaxUserNum());
        }

        //验证账户信息是否存在
        Map<String,SaasUser> saasUserMap = Maps.newHashMap();
        for (String userName:accounts) {
            SaasUser saasUser = saasUserDao.selectByUserName(userName);
            if (null == saasUser) {
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_402.getCode(), userName+"此用户名称不存在");
            }
            ObjectResponse<List<ParkDto>> parkList = parkService.getParkList(saasUser.getId());
            if (!ObjectResponse.isSuccess(parkList)||
                    !parkList.getData().stream().map(ParkDto::getId).collect(Collectors.toList()).contains(park.getId())){
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_402.getCode(), userName+"此用户没有当前车场的管理的权限,无法成为座席专员");
            }
            ArrayList<String> roleNames = Lists.newArrayList("车场管理员", "云岗亭管理员", "系统管理员");
            String roleName = saasUserDao.getRoleName(saasUser.getRoleId());
            if (!roleNames.contains(roleName)) {
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_402.getCode(), userName+"此用户角色不能设置座席专员");
            }
            saasUserMap.put(saasUser.getUsername(),saasUser);
        }
        List<ParkVipUser> list = parkVipUserService.list(Wrappers.lambdaQuery(ParkVipUser.class)
                .eq(ParkVipUser::getParkVipId, parkVip.getId()));
        if (CollectionUtils.isEmpty(list)){
            accounts.forEach(userName->{
                SaasUser saasUser = saasUserMap.get(userName);
                ParkVipUser parkVipUser = new ParkVipUser();
                parkVipUser.setParkVipId(parkVip.getId());
                parkVipUser.setUserId(saasUser.getId());
                parkVipUser.setAuthStatus(ParkuserAuthStatus.apply.getType());
                parkVipUser.setSetPhone(Boolean.FALSE);
                setSip(saasUser);
                parkVipUser.setStatus(1);
                parkVipUser.setCreateTime(new Date());
                parkVipUserService.save(parkVipUser);
            });
        } else {
            List<Integer> viewIds = Lists.newArrayList();
            for (String userName:accounts) {
                SaasUser saasUser = saasUserMap.get(userName);
                viewIds.add(saasUser.getId());
            }
            List<Integer> dbIds = list.stream().map(ParkVipUser::getUserId).collect(Collectors.toList());
            //获取两个集合的交集
            Collection<Integer> intersectionIds = CollectionUtil.intersection(viewIds, dbIds);
            //添加集合
            List<Integer> addIds = CollectionUtil.subtractToList(viewIds, intersectionIds);
            //取消授权集合
            List<Integer> removeIds = CollectionUtil.subtractToList(dbIds, intersectionIds);

            if (CollectionUtil.isNotEmpty(intersectionIds)){
                intersectionIds.forEach(userId->{
                    ParkVipUser parkVipUser = parkVipUserService.getOne(Wrappers.lambdaQuery(ParkVipUser.class)
                            .eq(ParkVipUser::getUserId, userId)
                            .and(query->{
                                query.eq(ParkVipUser::getParkVipId,parkVip.getId());
                            }).last(SqlConstant.LIMIT_ONE));
                    if (parkVipUser != null){
                        if (ParkuserAuthStatus.cancel.getType().equals(parkVipUser.getAuthStatus())){
                            parkVipUser.setAuthStatus(ParkuserAuthStatus.apply.getType());
                            parkVipUser.setStatus(1);
                            parkVipUser.setSetPhone(Boolean.FALSE);
                            parkVipUser.setUpdateTime(new Date());
                            setSip(userId);
                            parkVipUserService.updateById(parkVipUser);
                        }
                    }
                });
            }
            if (CollectionUtil.isNotEmpty(addIds)){
                addIds.forEach(userId->{
                    ParkVipUser parkVipUser = parkVipUserService.getOne(Wrappers.lambdaQuery(ParkVipUser.class)
                            .eq(ParkVipUser::getUserId, userId)
                            .and(query->{
                                query.eq(ParkVipUser::getParkVipId,parkVip.getId());
                            }).last(SqlConstant.LIMIT_ONE));
                    if (parkVipUser ==null){
                        parkVipUser = new ParkVipUser();
                        parkVipUser.setParkVipId(parkVip.getId());
                        parkVipUser.setUserId(userId);
                        parkVipUser.setAuthStatus(ParkuserAuthStatus.apply.getType());
                        parkVipUser.setSetPhone(Boolean.FALSE);
                        parkVipUser.setStatus(1);
                        setSip(userId);
                        parkVipUser.setCreateTime(new Date());
                        parkVipUserService.save(parkVipUser);
                    }
                });
            }
            if (CollectionUtil.isNotEmpty(removeIds)){
                removeIds.forEach(userId->{
                    ParkVipUser parkVipUser = parkVipUserService.getOne(Wrappers.lambdaQuery(ParkVipUser.class)
                            .eq(ParkVipUser::getUserId, userId)
                            .and(query->{
                                query.eq(ParkVipUser::getParkVipId,parkVip.getId());
                            }).last(SqlConstant.LIMIT_ONE));
                    if (parkVipUser != null){
                        parkVipUser.setAuthStatus(ParkuserAuthStatus.cancel.getType());
                        parkVipUser.setStatus(1);
                        receiveSip(userId);
                        parkVipUser.setSetPhone(Boolean.FALSE);
                        parkVipUser.setUpdateTime(new Date());
                        callSipService.receiveSip(saasUserDao.load(userId).getSeatNumber());
                        parkVipUserService.updateById(parkVipUser);
                    }
                });
            }
        }
        parkVip.setLinkPhone(phoneNum);
        parkVipService.updateById(parkVip);

        //发送邮件通知MQ
        VipNotifyEmailVO vo = new VipNotifyEmailVO();
        vo.setAccounts(accounts);
        vo.setLinkPhone(phoneNum);
        vo.setPhoneNum(parkVip.getPhoneNum());
        vo.setParkName(park.getParkName());
        vo.setApplyTime(parkVip.getApplyTime());
        rabbitSender.sendMessage(MqConstants.Exchange.NOTIFY_EXCHANGE, MqConstants.Routing.NOTIFY_VIP_EMAIL_ROUTING, vo);
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<ParkAuthUserBaseDto> getAuthUser(String parkCode) {
        Park park = parkService.findByParkCode(parkCode).getData();
        if (Objects.isNull(park)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_402);
        }
        ParkAuthUserBaseDto parkAuthUserBaseDto = new ParkAuthUserBaseDto();
        parkAuthUserBaseDto.setPhoneNum("15511331201");
        List<ParkAuthUserDto> items = Lists.newArrayList();
        ParkAuthUserDto parkAuthUserDto = new ParkAuthUserDto();
        parkAuthUserDto.setAccount("admin");
        parkAuthUserDto.setStatus(3);
        items.add(parkAuthUserDto);
        parkAuthUserBaseDto.setItems(items);
        return ObjectResponse.success(parkAuthUserBaseDto);
    }

    private void setSip(SaasUser saasUser){
        if (StringUtils.isEmpty(saasUser.getSeatNumber())){
            saasUser.setSeatNumber(callSipService.getSip());
        }
        saasUser.setSeatType(3);
        saasUserDao.update(saasUser);
    }
    private void setSip(Integer userId){
        SaasUser saasUser = saasUserDao.load(userId);
        setSip(saasUser);
    }
    private void receiveSip(Integer userId){
        SaasUser saasUser = saasUserDao.load(userId);
        String seatNumber = saasUser.getSeatNumber();
        if (StringUtils.isNotEmpty(saasUser.getSeatNumber())){
            callSipService.receiveSip(seatNumber);
        }
        //如果该用户没有关联其他车程的vip坐席则不进行更新
        ParkVipUser query = new ParkVipUser();
        query.setUserId(userId);
        query.setAuthStatus(ParkuserAuthStatus.success.getType());
        ParkVipUser parkVipUser = parkVipUserService.getOneByEntity(query);
        if (Objects.isNull(parkVipUser)){
            saasUser.setSeatNumber(null);
            saasUser.setSeatType(null);
            saasUserDao.update(saasUser);
        }
    }
}
