package com.icetech.park.rpc;

import com.icetech.cloudcenter.api.discount.IParkDiscountUserchargeService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.discount.ParkDiscountUsercharge;
import com.icetech.park.service.discount.ParkDiscountUserchargeService;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * 车场优惠券配置服务
 * @author wangzhiwei
 */
@Service("iParkDiscountUserchargeServiceImpl")
public class IParkDiscountUserchargeServiceImpl implements IParkDiscountUserchargeService {
    @Autowired
    private ParkDiscountUserchargeService parkDiscountUserchargeService;
    @Autowired
    private ParkService parkService;

    @Override
    public ObjectResponse<ParkDiscountUsercharge> getParkDiscountUserchargeByParkId(Long parkId) {
        ParkDiscountUsercharge parkDiscountUsercharge = parkDiscountUserchargeService.getParkDiscountUserchargeByParkId(parkId);
        if(Objects.isNull(parkDiscountUsercharge)){
            // 设置默认值
            parkDiscountUsercharge = new ParkDiscountUsercharge();
            parkDiscountUsercharge.setParkId(parkId);
            parkDiscountUsercharge.setPlateGetCoupons(1);
            parkDiscountUsercharge.setSupportStackeUsage(2);
            parkDiscountUsercharge.setThirdpartyStackeUsage(1);
            parkDiscountUsercharge.setUserMultipleTimes(2);
            return ObjectResponse.success(parkDiscountUsercharge);
        }
        return ObjectResponse.success(parkDiscountUsercharge);
    }

    @Override
    public ObjectResponse<ParkDiscountUsercharge> getParkDiscountUserchargeByParkCode(String parkCode) {
        Long parkId = parkService.findByParkCode(parkCode).getData().getId();
        return getParkDiscountUserchargeByParkId(parkId);
    }
}
