package com.icetech.park.rpc;

import com.icetech.cloudcenter.api.park.IParkAdvertService;
import com.icetech.park.domain.entity.park.ParkAdvert;
import com.icetech.park.service.park.ParkAdvertService;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author wangzhiwei
 */
@Service("iParkAdvertServiceImpl")
public class IParkAdvertServiceImpl implements IParkAdvertService {
    @Autowired
    private ParkAdvertService parkAdvertService;

    @Override
    public ObjectResponse<ParkAdvert> getByParkCode(String parkCode) {
        ParkAdvert parkAdvert = parkAdvertService.getByParkCode(parkCode);
        if (Objects.isNull(parkAdvert)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(parkAdvert);
    }
}
