package com.icetech.park.mongo.document;

import java.io.Serializable;
import java.util.Date;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 入场记录表
 */
@Getter
@Setter
@ToString
//@Document(value = "ice_enter_record")
public class EnterRecord implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * _id
     */
    //@MongoId
    protected String id;
    /**
     * 记录类型（1:进场;2:出场）
     */
    //@Field(value = "record_type")
    protected Integer recordType;
    /**
     * 订单号
     */
    //@Field(value = "order_num")
    protected String orderNum;
    /**
     * 车场id
     */
    //@Field(value = "park_id")
    protected Long parkId;
    /**
     * 车牌号
     */
    //@Field(value = "plate_num")
    protected String plateNum;
    /**
     * 进场时间
     */
    //@Field(value = "enter_time")
    protected Long enterTime;
    /**
     * 离场时间
     */
    //@Field(value = "exit_time")
    protected Long exitTime;
    /**
     * 车辆类型(1临时车2月卡车3特殊车辆，默认1)
     */
    //@Field(value = "type")
    protected Integer type;
    /**
     * 区域id
     */
    //@Field(value = "region_id")
    protected Long regionId;
    /**
     * 是否有子级，0：否，1：是，默认为0
     */
    //@Field(value = "has_son")
    protected Integer hasSon;
    /**
     * 车型(2大型车、1小型车，默认1)
     */
    //@Field(value = "car_type")
    protected Integer carType;
    /**
     * 入口位置
     */
    //@Field(value = "enter_no")
    protected String enterNo;
    /**
     * 出口位置
     */
    //@Field(value = "exit_no")
    protected String exitNo;
    /**
     * 图片
     */
    //@Field(value = "image")
    protected String image;
    /**
     * 操作员/收费员
     */
    //@Field(value = "oper_account")
    protected String operAccount;
    /**
     * 通道id
     */
    //@Field(value = "channel_id")
    protected String channelId;
    /**
     * 车辆描述
     */
    //@Field(value = "car_desc")
    protected String carDesc;
    /**
     * 车辆品牌
     */
    //@Field(value = "car_brand")
    protected String carBrand;
    /**
     * 车辆颜色
     */
    //@Field(value = "car_color")
    protected String carColor;
    /**
     * 本地订单号
     */
    //@Field(value = "local_order_num")
    protected String localOrderNum;
    /**
     * 出/入场事件：1车牌识别入场、2扫二维码入场
     */
    //@Field(value = "inout_event")
    protected Integer inoutEvent;
    /**
     * 出/入场操作：1自动开闸、2远程开闸、3本地开闸
     */
    //@Field(value = "inout_opening")
    protected Integer inoutOpening;
    /**
     * 触发方式，1：地感，2：视频，3：软触发
     */
    //@Field(value = "trigger_type")
    protected Integer triggerType;
    /**
     * 车牌颜色
     */
    //@Field(value = "plate_color")
    protected String plateColor;
    /**
     * 虚假车牌信息（1：真牌、0：假牌）
     */
    //@Field(value = "sham_flag")
    protected Integer shamFlag;
    /**
     * 置信度，范围在0到28之间，依次是由低到高
     */
    //@Field(value = "reliability")
    protected Integer reliability;
    /**
     * 车辆小图片
     */
    //@Field(value = "small_image")
    protected String smallImage;
    /**
     * 主订单编号
     */
    //@Field(value = "master_num")
    protected String masterNum;
    /**
     * 创建时间
     */
    //@Field(value = "create_time")
    protected Date createTime;
}
