package com.icetech.park.handle;

import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.service.down.CaptureService;
import com.icetech.park.service.down.ExHintService;
import com.icetech.park.service.down.FreeSpaceSyncService;
import com.icetech.park.service.down.RemoteOperaService;
import com.icetech.park.service.down.full.impl.FreeSpaceShowServiceImpl;
import com.icetech.park.service.down.full.impl.FullCloudGpIoOutServiceImpl;
import com.icetech.park.service.down.full.impl.FullCloudSerialDataServiceImpl;
import com.icetech.park.service.down.full.impl.FullCloudSnapShotServiceImpl;
import com.icetech.park.service.down.p2c.impl.FreeSpaceServiceImpl;
import com.icetech.park.service.down.p2c.impl.HintServiceImpl;
import com.icetech.park.service.down.p2c.impl.P2cRemoteSwitchServiceImpl;
import com.icetech.park.service.down.p2c.impl.SoftTriggerServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 生成设备下发服务类的工厂
 * @author fangct
 */
@Component
public class DeviceDownServiceFactory {

    @Autowired
    private ParkService parkService;
    @Autowired
    private P2cRemoteSwitchServiceImpl p2cRemoteSwitchService;
    @Autowired
    private FullCloudGpIoOutServiceImpl fullDownGpIoOutService;
    @Autowired
    private HintServiceImpl hintService;
    @Autowired
    private FullCloudSerialDataServiceImpl fullDownSerialDataService;
    @Autowired
    private SoftTriggerServiceImpl softTriggerService;
    @Autowired
    private FullCloudSnapShotServiceImpl fullDownSnapShotService;
    @Resource
    private FreeSpaceServiceImpl freeSpaceService;
    @Resource
    private FreeSpaceShowServiceImpl freeSpaceShowService;

    public RemoteOperaService buildRemoteOperaService(String parkCode) {
        ObjectResponse<ParkConfig> objectResponse = parkService.getParkConfig(parkCode);
        ObjectResponse.notError(objectResponse, "车场高级配置不存在");

        ParkConfig parkConfig = objectResponse.getData();
        if (DataCollectionEnum.端云.getType().equals(parkConfig.getDataCollection())) {
            return p2cRemoteSwitchService;
        } else if (DataCollectionEnum.纯云.getType().equals(parkConfig.getDataCollection())) {
            return fullDownGpIoOutService;
        }
        return null;
    }
    public ExHintService buildExHintService(String parkCode) {
        ObjectResponse<ParkConfig> objectResponse = parkService.getParkConfig(parkCode);
        ObjectResponse.notError(objectResponse, "车场高级配置不存在");

        ParkConfig parkConfig = objectResponse.getData();
        if (DataCollectionEnum.端云.getType().equals(parkConfig.getDataCollection())) {
            return hintService;
        } else if (DataCollectionEnum.纯云.getType().equals(parkConfig.getDataCollection())) {
            return fullDownSerialDataService;
        }
        return null;
    }
    public CaptureService buildCaptureService(String parkCode) {
        ObjectResponse<ParkConfig> objectResponse = parkService.getParkConfig(parkCode);
        ObjectResponse.notError(objectResponse, "车场高级配置不存在");

        ParkConfig parkConfig = objectResponse.getData();
        if (DataCollectionEnum.端云.getType().equals(parkConfig.getDataCollection())) {
            return softTriggerService;
        } else if (DataCollectionEnum.纯云.getType().equals(parkConfig.getDataCollection())) {
            return fullDownSnapShotService;
        }
        return null;
    }
    public FreeSpaceSyncService buildFreeSpaceSync(String parkCode) {
        ObjectResponse<ParkConfig> objectResponse = parkService.getParkConfig(parkCode);
        ObjectResponse.notError(objectResponse, "车场高级配置不存在");

        ParkConfig parkConfig = objectResponse.getData();
        if (DataCollectionEnum.端云.getType().equals(parkConfig.getDataCollection())) {
            return freeSpaceService;
        } else if (DataCollectionEnum.纯云.getType().equals(parkConfig.getDataCollection())) {
            return freeSpaceShowService;
        }
        return null;
    }
}
