package com.icetech.park.dao.parkvip;

import com.icetech.cloudcenter.domain.parkvip.VipBuyerRecord;
import com.icetech.cloudcenter.domain.parkvip.VipBuyerRecordDto;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 会员开通记录 Mapper 接口
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
@Mapper
public interface VipBuyerRecordMapper extends SuperMapper<VipBuyerRecord> {

    /**
     * 获取vip购买记录
     * @param parkIds
     * @param userId
     * @return
     */
    List<VipBuyerRecordDto> getVipRecordList(@Param("parkIds") List<Long> parkIds, @Param("userId") Integer userId);

    /**
     * 获取vip支付金额
     *
     * @param startTime
     * @param endTime
     * @return
     */
    BigDecimal getVipAmount(@Param("startTime") String startTime, @Param("endTime") String endTime);
}

