package com.icetech.park.dao.parkvip;

import com.icetech.cloudcenter.domain.parkvip.ParkVip;
import com.icetech.cloudcenter.domain.parkvip.ParkVipDto;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 车场会员 Mapper 接口
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
@Mapper
public interface ParkVipMapper extends SuperMapper<ParkVip> {

    /**
     * 车场信息查询
     * @param parkIds
     * @param parkCode
     * @param status
     * @return
     */
    List<ParkVipDto> getParkVipList(@Param("parkIds") List<Long> parkIds, @Param("parkCode") String parkCode, @Param("status") Integer status);

    /**
     * 带有结账金额的列表统计
     * @param parkIds
     * @param parkCode
     * @return
     */
    List<ParkVipDto> getParkVipListWithMoney(@Param("parkIds") List<Long> parkIds, @Param("parkCode") String parkCode,@Param("userId") Integer userId);
}
