package com.icetech.park.dao.park;

import com.icetech.db.mybatis.base.mapper.SuperMapper;
import com.icetech.park.domain.entity.park.ParkVisit;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

public interface ParkVisitDao extends SuperMapper<ParkVisit> {
    int insert(ParkVisit parkVisit);

    List<ParkVisit> findAllByIds(@Param("ids") List<Long> ids, @Param("deleteFlag") Boolean deleteFlag);

    ParkVisit selectByVisitNum(@Param("visitNum") String visitNum);
    int updateVisit(ParkVisit parkVisit);
    List<ParkVisit> selectVisitRecords(@Param("mpUserId")Integer mpUserId);
    List<ParkVisit> selectVisitRecordsV2(@Param("mpUserId")Integer mpUserId, @Param("checkStatus")List<Integer> checkStatus, @Param("visitStatus")List<Integer> visitStatus, @Param("from")List<Integer> from);
    ParkVisit selectVisitByParkidPlate(@Param("parkId")Long parkId,@Param("plateNum")String plateNum,@Param("nowDate")String nowDate);
    ParkVisit selectvisitById(@Param("vId") Long vId);
    int countVisitRecords(@Param("mpUserId")Integer mpUserId);
    /**
     * 模糊查询有效月卡
     * @param parkId
     * @param partOfPlateList
     * @return
     */
    String fuzzyValidatePlate(@Param("parkId") Long parkId, @Param("partOfPlateList") List<String> partOfPlateList);

    /**
     * 某个时间后 预约数据
     * @param parkId
     * @param from
     * @return
     */
    List<String> selectVisitOtherByDate(@Param("parkId")Long parkId,@Param("from")Integer from,@Param("startTime")String startTime,@Param("checkStatus")Integer checkStatus);


    /**
     * 获取海大已添加访客次数
     *
     * @param ids
     * @return
     */
    Integer haiDaCount(@Param("ids") List<Integer> ids);

    /**
     * 获取预约记录
     *
     * @param parkId
     * @param date
     * @return
     */
    List<ParkVisit> selectParkVisitList(@Param("parkId") Long parkId, @Param("date")Date date);

    ParkVisit selectVisitByParkIdAndPlate(@Param("parkId")Integer parkId,@Param("plateNum")String plateNum);

}
