package com.icetech.park.dao.other;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.park.domain.entity.ChannelAlarmHandler;
import com.icetech.cloudcenter.domain.request.ManagerInOutRequest;
import com.icetech.cloudcenter.domain.vo.ChannelAlarmHandlerVo;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 进出口报警处理表 Mapper 接口
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-07-21
 */
@Mapper
public interface ChannelAlarmHandlerMapper extends SuperMapper<ChannelAlarmHandler> {

    /**
     * Description: 处理记录查询
     * Version1.0 2021-07-23 by wgy 创建
     *
     * @param page      请求参数
     * @param request      请求参数
     * @param parkIds                   车场id集合
     * @return java.util.List<com.icetech.cloudcenter.domain.vo.PlateRecheckVo>
     */
    List<ChannelAlarmHandlerVo> selectChannelAlarmHandlerVo(Page<?> page, @Param("request") ManagerInOutRequest request, @Param("parkIds") String parkIds);

}