package com.icetech.park.dao.other;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.cloudcenter.rpc.domain.param.ChannelAlarmParam;
import com.icetech.park.domain.entity.ChannelAlarm;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 进出口报警记录表 Mapper 接口
 * </p>
 *
 * @author fangct
 * @since 2020-06-16
 */
public interface ChannelAlarmDao {

    /**
     * 添加报警记录
     * @param channelAlarm
     * @return
     */
    int insert(ChannelAlarm channelAlarm);

    /**
     * 查询待处理状态的记录
     * @param parkId
     * @param channelCode
     * @param alarmType
     * @return
     */
    ChannelAlarm selectOneByParkIdAndChannelCode(@Param("parkId") Long parkId,
                                                 @Param("channelCode") String channelCode,
                                                 @Param("alarmType") Integer alarmType);

    /**
     * 查询待处理状态的记录
     * @param parkId        车场id
     * @param channelCode   通道id
     * @return
     */
    List<ChannelAlarm> selectByParkIdAndChannelCode(@Param("parkId") Long parkId, @Param("channelCode") String channelCode);

    /**
     * id必传
     * @param channelAlarm
     * @return
     */
    int updateById(ChannelAlarm channelAlarm);

    /**
     * 查询出入口报警集合
     * @param page          分页参数
     * @param parkIds       车场id
     * @return
     */
    List<ChannelAlarm> selectAlarmList(Page<?> page, @Param("parkIds") String parkIds);

    /**
     * 查询滞留车辆数
     * @param parkIds   车场id 集合
     * @return
     */
    Integer selectAlarmCount(@Param("parkIds") String parkIds);

    /**
     * 根据车场ID和通道编号更新
     * @param channelAlarm
     */
    void update(ChannelAlarm channelAlarm);

    /**
     * 查询
     * @param parkId
     * @param status
     * @param time
     * @return
     */
    List<ChannelAlarm> getChannelAlarmTimeOut(@Param("parkId") Long parkId,@Param("status") Integer status,@Param("time") Date time);

    List<ChannelAlarm> getAlarmsByParam(ChannelAlarmParam param);
}
