package com.icetech.park.dao.made;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.park.domain.entity.MadePlate;
import com.icetech.cloudcenter.domain.request.ManagerInOutRequest;
import com.icetech.cloudcenter.domain.vo.MadePlateVo;
import com.icetech.db.dao.BaseDao;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 车牌置信度低人工修正表
 * @author zhangpengzhan
 */
@Repository
public interface MadePlateDao extends BaseDao<MadePlate> {
    MadePlate selectByOrderNum(@Param("orderNum") String orderNum);

    /**
     * 车牌复审记录
     * @param page      分页参数
     * @param request   请求参数
     * @param parkIds   车场id集合
     * @return  MadePlateVo
     */
    List<MadePlateVo> selectMadePlateVo(Page<?> page, @Param("request") ManagerInOutRequest request, @Param("parkIds") String parkIds);
}
