package com.icetech.park.dao.made;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.park.domain.entity.IotPlate;
import com.icetech.cloudcenter.domain.request.ManagerInOutRequest;
import com.icetech.cloudcenter.domain.vo.PlateRecheckVo;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 车牌二次识别 Mapper 接口
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-07-22
 */
@Mapper
public interface IotPlateMapper extends SuperMapper<IotPlate> {

    /**
     * Description: 车牌复审数量
     * Version1.0 2021-07-22 by wgy 创建
     * 
     * @param request   请求参数
     * @param parkIds   车场id集合
     * @return java.lang.Integer       
     */
    Integer selectPlateCount(@Param("request") ManagerInOutRequest request, @Param("parkIds") String parkIds);

    /**
     * Description: 车辆复审列表查询
     * Version1.0 2021-07-23 by wgy 创建
     * 
     * @param page      请求参数
     * @param request      请求参数
     * @param parkIds                   车场id集合
     * @return java.util.List<com.icetech.cloudcenter.domain.vo.PlateRecheckVo>       
     */
    List<PlateRecheckVo> selectRecheckVo(Page<?> page, @Param("request") ManagerInOutRequest request, @Param("parkIds") String parkIds);
}