package com.icetech.park.dao.ledsound;


import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.park.domain.entity.led.LedTips;
import com.icetech.db.mybatis.base.mapper.SuperMapper;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author fangct
 * @since 2019-12-24
 */
public interface LedTipsDao extends SuperMapper<LedTips> {
    default LedTips selectByParkId(Long parkId) {
        return selectLimitOne(Wrappers.lambdaQuery(LedTips.class).eq(LedTips::getParkId, parkId).isNull(LedTips::getChannelId));
    }

    default LedTips selectByChannelId(Long channelId) {
        return selectLimitOne(Wrappers.lambdaQuery(LedTips.class).eq(LedTips::getChannelId, channelId));
    }

    default LedTips selectDefault() {
        return selectLimitOne(Wrappers.lambdaQuery(LedTips.class).isNull(LedTips::getParkId));
    }
}
