package com.icetech.park.dao.ledsound;

import java.util.List;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.park.domain.entity.led.LedSound;
import com.icetech.db.mybatis.base.mapper.SuperMapper;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author fangct
 * @since 2019-12-24
 */
public interface LedSoundDao extends SuperMapper<LedSound> {
    default List<LedSound> selectByParkId(Long parkId) {
        return selectList(Wrappers.lambdaQuery(LedSound.class).eq(LedSound::getParkId, parkId).isNull(LedSound::getChannelId));
    }

    default List<LedSound> selectByChannelId(Long channelId) {
        return selectList(Wrappers.lambdaQuery(LedSound.class).eq(LedSound::getChannelId, channelId));
    }

    default List<LedSound> selectParkDefault() {
        return selectList(Wrappers.lambdaQuery(LedSound.class).isNull(LedSound::getParkId));
    }

    default LedSound selectParkDefaultByType(int type) {
        return selectLimitOne(Wrappers.lambdaQuery(LedSound.class).isNull(LedSound::getParkId).eq(LedSound::getSoundType, type));
    }

    default LedSound selectByParkIdAndType(Long parkId, int type) {
        return selectLimitOne(Wrappers.lambdaQuery(LedSound.class).eq(LedSound::getParkId, parkId).isNull(LedSound::getChannelId).eq(LedSound::getSoundType, type));
    }

    default LedSound selectByChannelIdAndType(Long channelId, int type) {
        return selectLimitOne(Wrappers.lambdaQuery(LedSound.class).eq(LedSound::getChannelId, channelId).eq(LedSound::getSoundType, type));
    }
}
