package com.icetech.park.dao.ledsound;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.db.mybatis.base.mapper.SuperMapper;

import java.util.List;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author fangct
 * @since 2019-12-24
 */
public interface LedShowDao extends SuperMapper<LedShow> {
    default List<LedShow> selectByParkId(Long parkId) {
        return selectList(Wrappers.lambdaQuery(LedShow.class).eq(LedShow::getParkId, parkId).isNull(LedShow::getChannelId).orderByAsc(LedShow::getRowNum));
    }

    default List<LedShow> selectByChannelId(Long channelId) {
        return selectList(Wrappers.lambdaQuery(LedShow.class).eq(LedShow::getChannelId, channelId).orderByAsc(LedShow::getRowNum));
    }

    default List<LedShow> selectParkDefault() {
        return selectList(Wrappers.lambdaQuery(LedShow.class).isNull(LedShow::getParkId).orderByAsc(LedShow::getRowNum));
    }

    default List<LedShow> selectParkDefaultByType(int type) {
        return selectList(Wrappers.lambdaQuery(LedShow.class).isNull(LedShow::getParkId).eq(LedShow::getDisplayType, type).orderByAsc(LedShow::getRowNum));
    }

    default List<LedShow> selectByParkIdAndType(Long parkId, int type) {
        return selectList(Wrappers.lambdaQuery(LedShow.class).eq(LedShow::getParkId, parkId).isNull(LedShow::getChannelId).eq(LedShow::getDisplayType, type).orderByAsc(LedShow::getRowNum));
    }

    default List<LedShow> selectByChannelIdAndType(Long channelId, int type) {
        return selectList(Wrappers.lambdaQuery(LedShow.class).eq(LedShow::getChannelId, channelId).eq(LedShow::getDisplayType, type).orderByAsc(LedShow::getRowNum));
    }
}
