package com.icetech.park.dao.ledsound;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.db.mybatis.base.mapper.SuperMapper;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author fangct
 * @since 2019-12-24
 */
public interface LedConfigDao extends SuperMapper<LedConfig> {
    default LedConfig selectByParkId(long parkId) {
        return selectLimitOne(Wrappers.lambdaQuery(LedConfig.class)
                .eq(LedConfig::getParkId, parkId)
                .isNull(LedConfig::getChannelId)
                .orderByDesc(LedConfig::getId));
    }

    default LedConfig selectByChannelId(long channelId) {
        return selectLimitOne(Wrappers.lambdaQuery(LedConfig.class)
                .eq(LedConfig::getChannelId, channelId)
                .orderByDesc(LedConfig::getId));
    }

    default LedConfig selectDefault() {
        return selectLimitOne(Wrappers.lambdaQuery(LedConfig.class)
                .isNull(LedConfig::getParkId)
                .orderByDesc(LedConfig::getId));
    }
}
