package com.icetech.park.dao.lcd;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.park.domain.entity.lcd.LcdTips;
import com.icetech.db.mybatis.base.mapper.SuperMapper;

/**
 * <p>
 * lcd进出场提示配置 Mapper 接口
 * </p>
 *
 * @author fangct
 * @since 2020-05-19
 */
public interface LcdTipsDao extends SuperMapper<LcdTips> {
    default LcdTips selectByParkId(Long parkId) {
        return selectLimitOne(Wrappers.lambdaQuery(LcdTips.class).eq(LcdTips::getParkId, parkId).isNull(LcdTips::getChannelId));
    }

    default LcdTips selectByChannelId(Long channelId) {
        return selectLimitOne(Wrappers.lambdaQuery(LcdTips.class).eq(LcdTips::getChannelId, channelId));
    }

    default LcdTips selectDefault() {
        return selectLimitOne(Wrappers.lambdaQuery(LcdTips.class).isNull(LcdTips::getParkId));
    }
}
