package com.icetech.park.dao.lcd;

import java.util.List;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.park.domain.entity.lcd.LcdSoundcode;
import com.icetech.db.mybatis.base.mapper.SuperMapper;

/**
 * <p>
 * lcd语音编码表 Mapper 接口
 * </p>
 *
 * @author fangct
 * @since 2020-05-19
 */
public interface LcdSoundcodeDao extends SuperMapper<LcdSoundcode> {
    default LcdSoundcode selectByCode(String soundCode) {
        LcdSoundcode param = new LcdSoundcode();
        param.setSoundCode(soundCode);
        return selectLimitOne(param);
    }

    default List<LcdSoundcode> selectAll() {
        return selectList(Wrappers.emptyWrapper());
    }
}
