package com.icetech.park.dao.lcd;

import java.util.List;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.park.domain.entity.lcd.LcdSound;
import com.icetech.db.mybatis.base.mapper.SuperMapper;

/**
 * <p>
 * lcd语音配置 Mapper 接口
 * </p>
 *
 * @author fangct
 * @since 2020-05-19
 */
public interface LcdSoundDao extends SuperMapper<LcdSound> {
    default List<LcdSound> selectByParkId(Long parkId) {
        return selectList(Wrappers.lambdaQuery(LcdSound.class).eq(LcdSound::getParkId, parkId).isNull(LcdSound::getChannelId));
    }

    default List<LcdSound> selectByChannelId(Long channelId) {
        return selectList(Wrappers.lambdaQuery(LcdSound.class).eq(LcdSound::getChannelId, channelId));
    }

    default List<LcdSound> selectParkDefault() {
        return selectList(Wrappers.lambdaQuery(LcdSound.class).isNull(LcdSound::getParkId));
    }

    default LcdSound selectParkDefaultByType(int type) {
        return selectLimitOne(Wrappers.lambdaQuery(LcdSound.class).isNull(LcdSound::getParkId).eq(LcdSound::getSoundType, type));
    }

    default LcdSound selectByParkIdAndType(Long parkId, int type) {
        return selectLimitOne(Wrappers.lambdaQuery(LcdSound.class).eq(LcdSound::getParkId, parkId).isNull(LcdSound::getChannelId).eq(LcdSound::getSoundType, type));
    }

    default LcdSound selectByChannelIdAndType(Long channelId, int type) {
        return selectLimitOne(Wrappers.lambdaQuery(LcdSound.class).eq(LcdSound::getChannelId, channelId).eq(LcdSound::getSoundType, type));
    }
}
