package com.icetech.park.dao.lcd;

import java.util.List;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.park.domain.entity.lcd.LcdShow;
import com.icetech.db.mybatis.base.mapper.SuperMapper;

/**
 * <p>
 * lcd屏显每行配置 Mapper 接口
 * </p>
 *
 * @author fangct
 * @since 2020-05-19
 */
public interface LcdShowDao extends SuperMapper<LcdShow> {
    default List<LcdShow> selectByChannelId(Long channelId) {
        return selectList(Wrappers.lambdaQuery(LcdShow.class).eq(LcdShow::getChannelId, channelId));
    }

    default List<LcdShow> selectParkDefault() {
        return selectList(Wrappers.lambdaQuery(LcdShow.class).isNull(LcdShow::getParkId));
    }
}
