package com.icetech.park.dao.lcd;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.db.mybatis.base.mapper.SuperMapper;

/**
 * <p>
 * lcd屏显语音配置 Mapper 接口
 * </p>
 *
 * @author fangct
 * @since 2020-05-19
 */
public interface LcdConfigDao extends SuperMapper<LcdConfig> {
    /**
     * 根据车场ID查询
     * @param parkId
     * @return
     */
    default LcdConfig selectByParkId(Long parkId) {
        return selectLimitOne(Wrappers.lambdaQuery(LcdConfig.class).eq(LcdConfig::getParkId, parkId).isNull(LcdConfig::getChannelId));
    }

    default LcdConfig selectByChannelId(Long channelId) {
        return selectLimitOne(Wrappers.lambdaQuery(LcdConfig.class).eq(LcdConfig::getChannelId, channelId));
    }

    /**
     * 查询默认配置
     * @return
     */
    default LcdConfig selectDefault() {
        return selectLimitOne(Wrappers.lambdaQuery(LcdConfig.class).isNull(LcdConfig::getParkId));
    }
}
