package com.icetech.park.dao.lcd;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.park.domain.entity.lcd.LcdBrightness;
import com.icetech.db.mybatis.base.mapper.SuperMapper;

import java.util.List;

/**
 * <p>
 * lcd屏显亮度控制 Mapper 接口
 * </p>
 *
 * @author fangct
 * @since 2020-05-19
 */
public interface LcdBrightnessDao extends SuperMapper<LcdBrightness> {
    default List<LcdBrightness> findByLcdId(Long lcdId) {
        return selectList(Wrappers.lambdaQuery(LcdBrightness.class).eq(LcdBrightness::getLcdId, lcdId).orderByAsc(LcdBrightness::getSort));
    }
}
