package com.icetech.park.dao.invoice;

import com.icetech.cloudcenter.domain.response.InvoiceDetailResponse;
import com.icetech.cloudcenter.domain.response.InvoiceRecordResponse;
import com.icetech.park.domain.entity.invoice.InvoiceBlue;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

@Repository
public interface InvoiceBlueDao {
    int deleteByPrimaryKey(Integer id);

    int insert(InvoiceBlue record);

    InvoiceBlue selectByOrderId(String orderId);

    int updateByOrderId(InvoiceBlue record);

    /**
     * 获取 公众号下的所有开票记录
     * @param mpUserId
     * @param startTime
     * @param endTime
     * @param source
     * @return
     */
    List<InvoiceRecordResponse> selectByMpUserId(@Param("mpUserId") Integer mpUserId, @Param("startTime") Date startTime, @Param("endTime") Date endTime, @Param("source") Integer source);

    /**
     * 获取订单发票明细的返回
     * @param orderId
     * @return
     */
    InvoiceDetailResponse selectInvoiceDetailByOrderId(String orderId);

    /**
     * 根据订单号删除
     * @param orderId
     */
    int deleteByOrderId(String orderId);

    InvoiceBlue selectByThirdId(String thirdId);

    List<InvoiceBlue> selectByChannelAndStatus(@Param("channel") Integer channel, @Param("status") Integer status);

    List<String> selectCheckedTradeNoList(@Param("source") Integer source,@Param("plateNum") String plateNum, @Param("plateNumList") List<String> plateNumList);

}
