package com.icetech.park.dao;

import com.icetech.park.domain.dto.FirmwareUpgradeDTO;
import com.icetech.park.domain.dto.FirmwareUpgradeListDTO;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import com.icetech.park.domain.entity.FirmwareUpgrade;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 固件升级任务表 Mapper 接口
 * </p>
 *
 * @author fangct
 * @since 2021-04-06
 */
public interface FirmwareUpgradeDao extends SuperMapper<FirmwareUpgrade> {

    /**
     * 查询当次周期待升级列表
     *
     * @param startTime
     * @return
     */
    List<FirmwareUpgradeDTO> findWaitUpgradeList(String startTime);

    /**
     * 根据任务ID查询
     * @param taskId
     * @return
     */
    FirmwareUpgrade selectByTaskId(String taskId);

    /**
     * 根据SN号和状态查询最近任务
     * @param sn
     * @param status
     * @return
     */
    FirmwareUpgrade selectTaskBySnAndStatus(@Param("sn") String sn, @Param("status") Integer status);

    /**
     * 根据任务ID更新
     * @param firmwareUpgrade
     */
    void updateByTaskId(FirmwareUpgrade firmwareUpgrade);

    /**
     * 查询任务列表
     * @param parkIdList
     * @param sn
     * @param status
     * @param startTime
     * @param endTime
     * @return
     */
    List<FirmwareUpgradeListDTO> selectListByParam(@Param("parkIdList") List<Long> parkIdList, @Param("sn") String sn, @Param("status") Integer status, @Param("startTime") String startTime, @Param("endTime") String endTime);

}
