package com.icetech.park.dao;

import com.icetech.park.domain.dto.FirmwareDTO;
import com.icetech.park.domain.dto.FirmwareListDTO;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import com.icetech.park.domain.entity.Firmware;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 固件表 Mapper 接口
 * </p>
 *
 * @author fangct
 * @since 2021-04-06
 */
public interface FirmwareDao extends SuperMapper<Firmware> {

    /**
     * 按固件ID和版本号查询
     *
     * @param productModelId
     * @param firmwareVersion
     * @return
     */
    FirmwareDTO selectByModelAndVer(@Param("productModelId") Integer productModelId, @Param("firmwareVersion") String firmwareVersion);

    List<FirmwareListDTO> selectListByParam(@Param("productModelId") Integer productModelId, @Param("firmwareVersion") String firmwareVersion, @Param("startTime") String startTime, @Param("endTime") String endTime);

    /**
     * 根据产品型号ID查询固件
     *
     * @param productModelId
     * @return
     */
    List<Firmware> selectListByProductModelId(Integer productModelId);

    /**
     * 查询版本号
     *
     * @param productModelId
     * @param firmwareVersion
     * @return
     */
    List<Firmware> selectListByVersion(@Param("productModelId") Integer productModelId, @Param("firmwareVersion") String firmwareVersion);

    /**
     * 查询所有固件包的型号列表
     *
     * @return
     */
    List<Integer> selectAllProductModel();

}
