package com.icetech.park.config;

import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.icetech.park.domain.entity.sms.SmsAlarmRuleBase;
import com.icetech.park.domain.entity.sms.SmsAlarmRuleBaseNear;
import com.icetech.park.domain.entity.sms.SmsAlarmRuleBaseOffline;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Configuration;

@Slf4j
@Configuration
public class MybatisPlusConfig implements ApplicationRunner {
    @Override
    public void run(ApplicationArguments args) throws Exception {
        TableInfoHelper.initTableInfo(new MapperBuilderAssistant(new MybatisConfiguration(), ""), SmsAlarmRuleBase.class);
        TableInfoHelper.initTableInfo(new MapperBuilderAssistant(new MybatisConfiguration(), ""), SmsAlarmRuleBaseOffline.class);
        TableInfoHelper.initTableInfo(new MapperBuilderAssistant(new MybatisConfiguration(), ""), SmsAlarmRuleBaseNear.class);
        log.info("Mybatis Plus initTableInfo");
    }
}
