package com.icetech.park.config;

import cn.hutool.core.text.csv.CsvWriter;
import com.icetech.cloudcenter.domain.response.MonthCardDto;
import com.icetech.cloudcenter.domain.request.p2c.BlacklistRequest;
import com.icetech.cloudcenter.domain.request.p2c.VipInfoRequest;
import com.icetech.park.service.down.upload.IDataUploadService;
import com.icetech.oss.OssService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.io.File;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.List;

@Configuration
@Slf4j
public class AppConfig {

    @Autowired
    private OssService ossService;

    @Bean
    public IDataUploadService<MonthCardDto> uploadMonthCards() {
        return (dataList, headers, filePath) -> upload(dataList, headers, filePath);
    }
    @Bean
    public IDataUploadService<VipInfoRequest> uploadVips() {
        return (dataList, headers, filePath) -> upload(dataList, headers, filePath);
    }
    @Bean
    public IDataUploadService<BlacklistRequest> uploadBlacklist() {
        return (dataList, headers, filePath) -> upload(dataList, headers, filePath);
    }

    private <T> void upload(List<T> dataList, String[] headers, String filePath){
        String fullPath = "/home/work/tempFile/" + filePath;
        File file = new File(fullPath);
        // 创建CSV写对象
        CsvWriter csvWriter = new CsvWriter(fullPath, StandardCharsets.UTF_8);
        try {
            csvWriter.write(headers);
            for (int i = 0; i < dataList.size(); i++) {
                T ins = dataList.get(i);
                // 写内容
                String[] content = new String[headers.length];
                content[0] = String.valueOf(i + 1);
                for (int j = 1; j < headers.length; j++) {
                    try {
                        Field field = ins.getClass().getDeclaredField(headers[j]);
                        //设置对象的访问权限，保证对private的属性的访问
                        field.setAccessible(true);
                        Object val = field.get(ins);
                        if (val != null){
                            content[j] = String.valueOf(val).replace(",", "/");
                        }
                    } catch (NoSuchFieldException | IllegalAccessException e) {
                        content[j] = "";
                    }
                }
                csvWriter.write(content);
            }
            ossService.uploadFile(file, filePath);
        }finally {
            csvWriter.close();
            if (file.exists()){
                file.delete();
            }
        }
        log.info("[批量数据上传] 文件上传完成, 路径[{}]", filePath);
    }
}
