package com.icetech.park.component;

import com.icetech.park.snowflake.Snowflake;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class SnowFlackIdGenerator {

    private final static Snowflake snowflake = new Snowflake();

    public String nextIdAsString() {
        return String.valueOf(snowflake.nextId());
    }

    public long nextId() {
        return snowflake.nextId();
    }

    public long[] parse(long id) {
        return snowflake.parse(id);
    }
}
