package com.icetech.park.component;

import com.google.common.collect.Lists;
import com.icetech.cloudcenter.api.constants.MqConstants;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.domain.AsyncNotifyInterface;
import com.icetech.common.domain.AsyncNotifyMsg;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.SpringUtils;
import com.icetech.mq.sender.RabbitSender;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 异步通知消息发送
 * @author fangct
 */
@Component
@Slf4j
public class AsyncNotifyClient {

    @Resource
    private RabbitSender rabbitSender;
    @Resource
    private RedisUtils redisUtils;
    //MQ名称前缀
    private static final String MQ_NAME_PREFIX = "icecloud-";

    public void callBack(String messageId, String topicSource, String env, Object object) {
        if (topicSource == null) {
            log.warn("topic为空, 直接返回[{}]", messageId);
            return;
        }
        String mqName = MQ_NAME_PREFIX + (env == null ? SpringUtils.getActiveProfile() : env);
        //设置通知结果的内容
        redisUtils.setIfAbsent(AsyncNotifyInterface.getMessageKey(messageId), object, 10L);
        AsyncNotifyInterface.notify(messageId, topicSource, (routingKey) -> {
            AsyncNotifyMsg<Object> content = AsyncNotifyMsg.builder()
                    .topic(routingKey)
                    .messageId(messageId)
                    .message(object).build();
            if (env == null || env.equals(SpringUtils.getActiveProfile())) {
                log.debug("[异步通知到当前环境] mqName[{}], routingKey[{}], messageId[{}]", mqName, routingKey, messageId);
                rabbitSender.sendMessage(MqConstants.Exchange.NOTIFY_EXCHANGE, routingKey, content);
            } else {
                rabbitSender.sendMessage(MqConstants.Exchange.NOTIFY_EXCHANGE, routingKey, content,
                    0L, Lists.newArrayList(mqName));
            }
            log.info("[发送异步通知消息] mqName[{}], routingKey[{}], messageId[{}]", mqName, routingKey, messageId);
            return null;
        });
    }
}
