package com.icetech.park.domain.vo.full;

import com.alibaba.fastjson2.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.icetech.park.domain.dto.full.ResultDTO;
import lombok.Data;

import java.io.Serializable;

/**
 * @author wgq
 */
@Data
public class AlarmInfoPlateVO implements Serializable {

    /**
     * 通道
     */
    private int channel;

    /**
     * 设备名称，Base64编码
     */
    private String deviceName;

    /**
     * 设备IP地址
     */
    private String ipaddr;

    /**
     * 设备序列号
     */
    private String serialno;

    /**
     * 用户自定义信息，Base64编码
     */
    @JsonProperty("user_data")
    @JSONField(name = "user_data")
    private String userData;

    /**
     * 识别结果
     */
    private ResultDTO result;
}


