package com.icetech.park.domain.vo;

import com.icetech.park.domain.entity.WorkOrder;
import com.icetech.user.domain.vo.SaasCsUserVo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * Description WorkOrderDetailVo
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/11/28 14:25
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WorkOrderDetailVo extends WorkOrder implements Serializable {

    /**
     * 车场编码
     */
    private String parkCode;
    
    /**
     * 车场名称
     */
    private String parkName;

    /**
     * 通道名称
     */
    private String channelName;

    /**
     * 带域名的图片
     */
    private String imageUrlStr;
    
    /**
     * 取消原因
     */
    private String cancelReason;

    /**
     * 文本描述
     */
    private String textDesc;

    /**
     * 图片描述
     */
    private String pictureDesc;

    /**
     * 工单客服
     */
    private SaasCsUserVo saasCsUserVo;

}
