package com.icetech.park.domain.vo;

import com.icetech.park.domain.entity.park.ParkRecovery;
import lombok.Data;

/**
 * Description ParkRecoveryVo
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/7/25 10:38
 */
@Data
public class ParkRecoveryVo extends ParkRecovery {

    /**
     * 车场名称
     */
    private String parkName;

    /**
     * 欠费追缴状态，1-未开通，2-生效中，3-已过期
     */
    private Integer recoveryStatus;

    /** 是否启用追缴功能 0/1 */
    protected boolean enableRecovery = false;
    /** 是否只收取本车场欠费 0/1 */
    protected boolean onlyRecoverySelf = false;
    /** 是否允许收取路侧欠费 0/1 */
    protected boolean allowRecoveryRoad = false;
}
