package com.icetech.park.domain.vo;

import com.icetech.common.domain.Page;
import lombok.Data;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Description ParkTrusteeshipRecordPage
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/7/4 09:56
 */
@Data
public class ParkRecoveryApplyPage<T> extends Page<T> implements Serializable {

    /**
     * 总的月租服务费
     */
    private BigDecimal totalServiceCharge;

    /**
     * 角色类型，1-智芯和一级渠道管理员，2- 其他角色
     */
    private Integer roleType;

    public static <T> ParkRecoveryApplyPage<T> instance(int totalPage, long total, List<T> row) {
        ParkRecoveryApplyPage<T> page = new ParkRecoveryApplyPage<>();
        page.setTotalPage(totalPage);
        page.setTotal(total);
        page.setRows(row);
        return page;
    }
    
    
}
