package com.icetech.park.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.icetech.excel.anno.ExcelDictFormat;
import com.icetech.excel.convert.ExcelDictConvert;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wanggang
 * @create 2023-11-08 15:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class NotPaySubAccountVo implements Serializable {

    /**
     * id主键
     */
    @ExcelIgnore
    private Integer id;

    /**
     * 车场名称
     */
    @ExcelProperty(value = "车场名称")
    private String parkName;

    /**
     * 订单号
     */
    @ExcelIgnore
    private String orderNum;

    /**
     * 车牌号
     */
    @ExcelProperty(value = "车牌号")
    private String plateNum;

    /**
     * 车辆类型(1临时车2月卡车3特殊车辆)
     */
    @ExcelProperty(value = "车辆类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "1=临时车,2=月卡车,3=特殊车辆")
    private Integer type;

    /**
     * 进场时间
     */
    @ExcelProperty(value = "入场时间")
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    private Long enterTime;

    /**
     * 离场时间
     */
    @ExcelProperty(value = "离场时间")
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    private Long exitTime;

    /**
     * 停车时长
     */
    @ExcelProperty(value = "停车时长")
    private String parkTime;

    /**
     * 补缴金额
     */
    @ExcelProperty(value = "补缴金额")
    private BigDecimal paidPrice;

    /**
     * 支付方式，1现金，2微信，3支付宝，4银联
     */
    @ExcelProperty(value = "支付方式", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "1=现金,2=微信,3=支付宝,4=银联")
    private Integer payWay;

    /**
     * 支付时间
     */
    @ExcelProperty(value = "支付时间")
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    private Long payTime;

    /**
     * 分账时间
     */
    @ExcelProperty(value = "分账时间")
    private String divisionTime;

    /**
     * 平台分账比例
     */
    @ExcelProperty(value = "入账方分账比例")
    private BigDecimal divisionProfit;

    /**
     * 平台入账方收款金额
     */
    @ExcelProperty(value = "云上知位")
    private BigDecimal platformAmount;

    /**
     * 商户交易流水号
     */
    @ExcelProperty(value = "商户交易流水号")
    private String thirdTradeNo;

}
