package com.icetech.park.domain.vo;

import com.icetech.common.domain.Page;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Description ParkTrusteeshipRecordPage
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/7/4 09:56
 */
@Data
public class NotPaySubAccountPage<T> extends Page<T> implements Serializable {

    /**
     * 总的补交金额
     */
    private BigDecimal totalPaidPrice;

    /**
     * 平台入账方收款总金额(云上知位)
     */
    private BigDecimal totalPlatformAmount;

    public static <T> NotPaySubAccountPage<T> instance(int totalPage, long total, List<T> row) {
        NotPaySubAccountPage<T> page = new NotPaySubAccountPage<>();
        page.setTotalPage(totalPage);
        page.setTotal(total);
        page.setRows(row);
        return page;
    }
    
    
}
