package com.icetech.park.domain.request.sms;

import java.time.LocalDateTime;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.common.utils.DateUtils;
import com.icetech.park.domain.entity.sms.SmsAlarmSendRecord;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString(callSuper = true)
public class SmsAlarmSendRecordParam extends SmsAlarmSendRecord {
    /** 车场ID列表 */
    protected Set<Long> parkIds;
    protected Set<Long> permitParkIds;
    /** 收信手机号(模糊查询) */
    protected String recvPhonePart;
    /** 车牌号(模糊查询) */
    protected String plateNumPart;
    /** 车场数据采集方式 */
    protected Integer parkDataCollection;
    /** 提醒类型 */
    protected Set<Integer> smsTypes;
    /** 设备类型 */
    protected Set<Integer> deviceTypes;
    /** 车场通道ID */
    protected Set<Integer> channelIds;
    /** 最小发送时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime minSendTime;
    /** 最大发送时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime maxSendTime;

    /** 当前页数 */
    protected Integer pageNo = 1;
    /** 当前页数 */
    protected Integer pageIndex = 1;
    /** 分页条数 */
    protected Integer pageSize = 10;

    public void setPageNo(Integer pageNo) {
        setPageIndex(pageNo);
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageNo = pageIndex;
        this.pageIndex = pageIndex;
    }
}
