package com.icetech.park.domain.request.sms;

import java.util.Set;

import com.icetech.park.domain.entity.sms.SmsAlarmConfig;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString(callSuper = true)
@Accessors(chain = true)
public class SmsAlarmConfigParam extends SmsAlarmConfig {
    /** 车场ID列表 */
    protected Set<Long> parkIds;
    protected Set<Long> permitParkIds;
    /** 车场数据采集方式 */
    protected Integer parkDataCollection;

    protected String updateUser;

    /** 当前页数 */
    protected Integer pageNo = 1;
    /** 当前页数 */
    protected Integer pageIndex = 1;
    /** 分页条数 */
    protected Integer pageSize = 10;

    public void setPageNo(Integer pageNo) {
        setPageIndex(pageNo);
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageNo = pageIndex;
        this.pageIndex = pageIndex;
    }
}
