package com.icetech.park.domain.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Description ParkRecoveryOpenParam
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/7/24 15:40
 */
@Data
public class ParkRecoveryOpenParam implements Serializable {
    
    /**
     * 申请id
     */
    @NotNull(message = "申请id不能为空")
    @ApiModelProperty(value = "申请id", example = "1", required = true, position = 1)
    private Long recoveryApplyId;

    /**
     * 付费模式,1-溢价模式，2-固定收费模式，3-合作分成模式
     */
    @NotNull(message = "付费模式不能为空")
    @ApiModelProperty(value = "付费模式,1-溢价模式，2-固定收费模式，3-合作分成模式", example = "1", required = true, position = 1)
    private Integer payModel;

    /**
     * 开通月份时长
     */
    @NotNull(message = "月份时长不能为空")
    @ApiModelProperty(value = "开通月份时长", example = "1", required = true, position = 3)
    private Integer monthNum;
    
    /**
     * 支付人
     */
    @NotEmpty(message = "付款人姓名不能为空")
    @ApiModelProperty(value = "付款人姓名", example = "1", required = true, position = 4)
    private String payerName;

    /**
     * 合作分成模式的平台分账比例,模式 3 时必填
     */
    @ApiModelProperty(value = "合作分成模式的平台分账比例,模式 3 时必填", example = "1", position =  4)
    private BigDecimal divisionProfit;

    /**
     * 跳转的 url
     */
    private String returnUrl;
    
}
