package com.icetech.park.domain.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

@Data
public class OrderStatusParam {

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 离场时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date exitTime;

    /**
     * 入场时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date enterTime;

    /**
     * 处理原因
     */
    private String errorCauses;

    /**
     * 操作人
     */
    private String userName;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 车类型
     * 1小型车、 2大型车、默认1
     */
    private Integer carType;
}
