package com.icetech.park.domain.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class EnterEntryParam {

    /**
     * 车场ID
     */
    private Long parkId;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 入场时间 【秒】
     */
    private Long enterTime;

    /**
     * 车辆类型
     */
    private Integer cardType;

    /**
     * 车型
     */
    private Integer carType;

    /**
     * 车牌颜色
     */
    private String plateColor;

    /**
     * 用户
     */
    private String userName;

    @NotBlank(message = "备注不能为空")
    private String remark;
}
