package com.icetech.park.domain.enums;

import lombok.Getter;

/**
 * Description OrderAction
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/11/24 15:31
 */
@Getter
public enum OrderEvent {

    CREATE_ORDER(0, "创建订单"),
    ACCEPT_ORDER(1, "受理工单"),
    REJECT_ORDER(2, "退回工单"),
    COMPLETE_ORDER(3, "工单完成"),
    CANCEL_ORDER(4, "取消订单"),
    REOPEN_ORDER(5, "重新打开工单");

    private final int value;
    private final String description;

    OrderEvent(int value, String description) {
        this.value = value;
        this.description = description;
    }
    //通过 value 查询枚举值
    public static OrderEvent find(int value) {
        for (OrderEvent action : OrderEvent.values()) {
            if (action.value == value) {
                return action;
            }
        }
        return null;
    }

}
