package com.icetech.park.domain.entity.sms;

import java.util.LinkedHashSet;

import javax.annotation.Nonnull;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString(callSuper = true)
@Accessors(chain = true)
public class SmsAlarmRuleBaseOffline extends SmsAlarmRuleBase {
    /** 收信手机号(多个以,隔开, 最多10个) */
    @TableField(value = "`recv_phones`")
    protected String recvPhones;
    /** 首次报警间隔(分钟数) */
    @TableField(value = "`first_interval`")
    protected Integer firstInterval;
    /** 首次报警后, 未恢复正常报警间隔(分钟数) */
    @TableField(value = "`hold_interval`")
    protected Integer holdInterval;
    /** 最多发送次数 */
    @TableField(value = "`max_count`")
    protected Integer maxCount;

    @Nonnull
    public LinkedHashSet<String> getRecvPhoneSet() {
        LinkedHashSet<String> set = new LinkedHashSet<>();
        if (recvPhones == null) return set;
        String[] phones = recvPhones.split(",");
        for (int i = 0; i < phones.length; i++) {
            set.add(phones[i]);
        }
        return set;
    }
}
