package com.icetech.park.domain.entity.sms;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.common.utils.DateUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@TableName("`ice_sms_alarm_order`")
public class SmsAlarmOrder implements Serializable {
    /** ID */
    @TableId(value = "`id`")
    protected Long id;
    /** 车场id */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 订单编号 */
    @TableField(value = "`order_num`")
    protected String orderNum;
    /** 交易流水号 */
    @TableField(value = "`trade_no`")
    protected String tradeNo;
    /** 商户交易流水号 */
    @TableField(value = "`out_trade_no`")
    protected String outTradeNo;
    /** 商户订单号 */
    @TableField(value = "`out_order_num`")
    protected String outOrderNum;
    /** 下单时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TableField(value = "`order_time`")
    protected LocalDateTime orderTime;
    /** 购买/支付时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TableField(value = "`pay_time`")
    protected LocalDateTime payTime;
    /** 订单来源(1-云平台;2-App) */
    @TableField(value = "`order_source`")
    protected Integer orderSource;
    /** 支付渠道 */
    @TableField(value = "`pay_channel`")
    protected Integer payChannel;
    /** 支付方式(0-现金;1-银行卡;2-微信;3-支付宝) */
    @TableField(value = "`pay_method`")
    protected Integer payMethod;
    /** 支付金额 */
    @TableField(value = "`total_amount`")
    protected Double totalAmount;
    /** 套餐ID */
    @TableField(value = "`product_id`")
    protected Long productId;
    /** 短信数量 */
    @TableField(value = "`sms_count`")
    protected Integer smsCount;
    /** 是否开发票(0-未开;1-已开) */
    @TableField(value = "`invoice_flag`")
    protected Integer invoiceFlag;
    /** 备注 */
    @TableField(value = "`remark`")
    protected String remark;
    /** 创建时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TableField(value = "`create_time`")
    protected LocalDateTime createTime;
    /** 创建人 */
    @TableField(value = "`create_user`")
    protected String createUser;
    /** 更新时间 */
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TableField(value = "`update_time`")
    protected LocalDateTime updateTime;
}
