package com.icetech.park.domain.entity.smart;

import com.google.gson.annotations.SerializedName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * TODO
 *
 * @author zhangpengzhan
 * @date 2020/8/20 15:21
 * @description: 城市大脑数据记录表
 */
@Data
public class SmartCityHistoryInfo implements Serializable {
    /**
     * 主键
     */
    private Integer id;
    /**
     * 唯一标识码
     */
    @SerializedName("UID")
    private String uuid;
    /**
     * 照片ID
     */
    @SerializedName("photoID")
    private String photoId;
    /**
     * 照片ID
     */
    private String photoUrl;
    /**
     * 账单ID
     */
    @SerializedName("billID")
    private String billId;
    /**
     * 账单 交易金额
     */
    private Integer actualPay;
    /**
     * 出场ID
     */
    @SerializedName("endID")
    private String endId;

    /**
     * 车场ID
     *
     */
    private String parkingCode;
    /**
     * 入场ID
     */
    @SerializedName( "arriveID")
    private String arriveId;
    /**
     * 接口类型
     * 入场 出场 账单 图片
     * 0  1  2  3
     */
    private Integer interfaceType;
    /**
     * 上传成功标识
     */
    private Integer success;
    /**
     * 数据参数内容json 格式
     */
    private String params;
    /**
     * 数据创建时间
     */
    private Date createTime;
    /**
     * 数据更新时间
     */
    private Date updateTime;
}
