package com.icetech.park.domain.entity.park;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 车场欠费追缴月度结算
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-07-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_park_recovery_settle")
public class ParkRecoverySettle implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 所属机构
     */
    private Integer institutionId;

    /**
     * 月份
     */
    private String settleMonth;

    /**
     * 追缴金额
     */
    private BigDecimal recoveryMoney;

    /**
     * 佣金
     */
    private BigDecimal commission;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 渠道订单号
     */
    private String channelOrderNo;

    /**
     * 支付状态，0-未支付，1-已支付
     */
    private Integer payStatus;

    /**
     * 支付方式，1-微信，2-支付宝
     */
    private Integer payMethod;

    /**
     * 付款人
     */
    private String payer;

    /**
     * 付款时间
     */
    private Date payTime;

    /**
     * 1-有效
     */
    private Integer status;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 操作人
     */
    private String operator;


}
