package com.icetech.park.domain.entity.park;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 *  停车场license
 *
 *  Created by zys
 */
@Setter
@Getter
@ToString
public class ParkLicense implements Serializable {
    private static final long serialVersionUID = 42L;

    /**
     * id (主健自增)
     */
    private int id;
    /**
     * 类型 1=长期有效 2=固定期限
     */
    private int type;
    /**
     * 车场id
     */
    private Long parkId;

    /**
     * license
     */
    private String licenseNumber;

    /**
     * 有效天数（当类型为固定期限）
     */
    private int validDays;

    /**
     * 发放状态 0=未发放 1=已发放
     */
    private int grantStatus;

    /**
     * 启用状态 0=未使用 1=使用中 2=作废 3=已过期 默认0
     */
    private int enableStatus;

    /**
     * 发放时间
     */
    private Date grantTime;
    /**
     * 启用时间
     */
    private Date enableTime;
    /**
     * 失效时间
     */
    private Date invalidTime;

    /**
     *
     */
    private Date createTime;
    /**
     *
     */
    private Date updateTime;
    private String remark;
}
