package com.icetech.park.domain.entity.park;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 空车位信息表
 * </p>
 *
 * @author wangzw
 * @since 2018-11-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_park_freespace")
public class ParkFreespace implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 主键自增长id
     */
    @TableId(value = "`id`", type = IdType.AUTO)
    private Integer id;
    /**
     * 车场id
     */
    @TableField("`park_id`")
    private Long parkId;
    /**
     * 空车位，用于显示
     */
    @TableField("`free_space`")
    private Integer freeSpace;
    /**
     * 实际空车位
     */
    @TableField("`real_free_space`")
    private Integer realFreeSpace;
    /**
     * 车场总车位
     */
    @TableField("`total_num`")
    private Integer totalNum;
    /**
     * 更新时间
     */
    @TableField("`update_time`")
    private Date updateTime;

    public Integer getRealFreeSpace() {
        if (realFreeSpace == null) {
            return freeSpace;
        } else {
            return realFreeSpace;
        }
    }
}
